<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\File;
use App\Models\Page;
use Crypt;
use Session;
class PageController extends Controller
{
    function page(){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $data['page'] = Page::orderBy('id', 'ASC')->get();
     $hasPermission = permission($user_id, '20', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Pages View','20','','','','','','',''); 
        return view('backend.features.page' , $data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    function pageedit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '20', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['page']=Page::where('id',$id)->first();
        return view('backend.features.pageedit', $data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    
    
    
    function pagecreate(Request $request){
    $existingMobile = Page::where('page_url', $request->page_url)->first();
    $user_id=session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '20', 'action_add');
    if ($hasPermission) { 
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Page Url');
        return redirect()->back()->with($message['status'],$message['message']);
    }
        $create=new Page;
        $create->title = $request->title;
        $create->page_url = $request->page_url;
        $create->user_id = $user_id;
        $create->meta_title = $request->meta_title;
        $create->meta_keyword = $request->meta_keyword;;
        $create->meta_description = $request->meta_description;;
        $create->description = $request->description;

        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/page'), $img);
        $create->image = $img;
        }
        if ($request->banner) {
        $img = time() . 'banner.' . $request->banner->extension();
        $request->banner->move(public_path('uploads/page'), $img);
        $create->banner = $img;
        }
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->delete_status='1';
        $create->tokan=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        $create->save();
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
    insertLogsAPI($user_id,'1','Pages Add','20','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Pagess');
    return redirect()->back()->with($message['status'],$message['message']);
    }
         $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }  
    
    
    
    
    function pageupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '20', 'action_edit');
        if ($hasPermission) {    
    $existingMobile = Page::where('page_url', $request->page_url)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Page Url');
        return redirect()->back()->with($message['status'],$message['message']);
    }
    $update = Page::findOrFail($id);
    $before = json_encode($update);
        $update->title = $request->title;
        $update->page_url = $request->page_url;
        $update->user_id = $user_id;
        $update->meta_title = $request->meta_title;
        $update->meta_keyword = $request->meta_keyword;;
        $update->meta_description = $request->meta_description;;
        $update->description = $request->description;

        if ($request->hasFile('image')) {
        if ($update->image && file_exists(public_path('uploads/page/' . $update->image))) {
            unlink(public_path('uploads/page/' . $update->image));
        }

        $imgName = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/page'), $imgName);
        $update->image = $imgName;
        }
        if ($request->hasFile('banner')) {
        if ($update->banner && file_exists(public_path('uploads/page/' . $update->banner))) {
            unlink(public_path('uploads/page/' . $update->banner));
        }

        $imgName = time() . 'banner.' . $request->banner->extension();
        $request->banner->move(public_path('uploads/page'), $imgName);
        $update->banner = $imgName;
        }
        $update->created_by=$user_id;
        $update->panel_id='1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Pages Update','20','',$adduser,'','',$after,$before,''); 

    $message = fleshmessage(3,1,'Pages');
    return redirect(url('backend/features/page'))->with($message['status'],$message['message']);
}
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }   
    
    
    
    
    function pageajax(Request $request){
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $pagedata = Page::pageajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $pagecount = Page::pageajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $pagedata = Page::pageajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $pagecount = Page::pageajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($pagedata as $row) {
    $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
    if(permission($user_id,'20','action_edit')){$action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/pageedit/' . Crypt::encrypt($row->id)) . '">
                        <i class="fadeIn animated bx bx-pencil anji me-0"></i></a>';}
  
              $action .= '   </li>';
    $action .= '<li class="list-unstyled">';
    if ($row->delete_status=='1'){
      if(permission($user_id,'20','action_delete')){
    $action .= '<a href="' . asset('backend/pagedelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
    $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
    </div>';

   
     $data[] = array(
    "id" => $row->id, 
    "title" => $row->title,
    "status" => $status,
    "action" => $action
    );
    }
    
    $canViewGlobal = permission($user_id, '20', 'action_globle_view');
    $canAccessCity = permission($user_id, '20', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
    $query = DB::table('pages')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('pages')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('pages')->where('user_id', $user_id)->orderBy('id', 'ASC');

    } else {
    $query = DB::table('pages')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }
  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $pagecount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
        
        
        
    public function pagestatus(Request $request) {
    $id = $request->id;
    $statusstatus = Page::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Slider not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}   





    public function pagedelete(Request $request, $id)
    {
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '20', 'action_delete');
        if ($hasPermission) { 
    $delete = Page::findOrFail($id);
    if ($delete->image) {
        $logoPath = public_path('uploads/page/' . $delete->image);
        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }
    if ($delete->banner) {
        $bannerPath = public_path('uploads/page/' . $delete->banner);
        if (file_exists($bannerPath)) {
            @unlink($bannerPath);
        }
    }

    $delete->delete();
    $after = json_encode($delete);
    $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Page Delete','20','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Page');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
}
