<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Faq;
use App\Models\superadmin;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;

class FaqController extends Controller
{
     function faq(){
          $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '29', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','FAQ View','29','','','','','','','');
         return view('backend.features.faq');
     }
      $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }
     
     
 public function faqcreate(Request $request)
{
   $user_id = session('SUPERADMIN_ID');
   $hasPermission = permission($user_id, '29', 'action_add');
     if ($hasPermission) {
   
    $create = new Faq;
    $create->question = $request->question;
    $create->answer = $request->answer;

    $create->panel_id = '1';
    $create->created_by = $user_id;
    $create->user_id = $user_id;
    $create->token = reandum_code('50');
    $create->ip = CurrentTimestamp()['ip'];
    $create->strtotime = CurrentTimestamp()['strtotime'];
    $create->created_at = CurrentTimestamp()['datetime'];
    $create->updated_at = CurrentTimestamp()['datetime'];
    $create->save(); 
     $after = json_encode($create);
     $before = json_encode($create);
     $adduser=$create->id;
    insertLogsAPI($user_id,'1','FAQ Add','29','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'FAQ');
    return redirect(asset('backend/features/faq'))->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect()->back()->with($messagepremission['status'],$messagepremission['message']) ->send();
    }

 public function faqupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '29', 'action_edit');
     if ($hasPermission) {
    $id = Crypt::decrypt($request->id);
    $update = Faq::find($id);
    $before = json_encode($update);
    $update->question = $request->question;
    $update->answer = $request->answer;
    $update->panel_id = '1';
    $update->created_by = $user_id;
    $update->user_id = $user_id;
    $update->ip = CurrentTimestamp()['ip'];
    $update->strtotime = CurrentTimestamp()['strtotime'];
    $update->created_at = CurrentTimestamp()['datetime'];
    $update->updated_at = CurrentTimestamp()['datetime'];
    $update->save(); {
    $after = json_encode($update);
    $adduser = $update->id;
    insertLogsAPI($user_id,'3','FAQ Update','29','',$adduser,'','',$after,$before,'');
    $message = fleshmessage(3,1,'FAQ');
     return redirect(asset('backend/features/faq'))->with($message['status'],$message['message']);
}
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
}

}

 

function faqajax(Request $request){
    $draw   = $request->draw ?? 1;
    $start  = $request->start ?? 0;  
    $length = $request->length ?? 10;

    $columnIndex = isset($request->order[0]['column']) ? $request->order[0]['column'] : 0;
    $columnName  = isset($request->columns[$columnIndex]['data']) ? $request->columns[$columnIndex]['data'] : 'id';
    $columnSortOrder = isset($request->order[0]['dir']) ? $request->order[0]['dir'] : 'desc';
    $filltersearchValue = isset($request->columns[$columnIndex]['search']['value']) ? $request->columns[$columnIndex]['search']['value'] : '';
    $searchValue = $request->search['value'] ?? '';

    $user_id = session('SUPERADMIN_ID');


    if($user_id=='1'){
        
        $housesurveydata = Faq::faqajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Faq::faqajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);
    }else{
        $housesurveydata = Faq::faqajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$start);
        $housesurveycount = Faq::faqajax($draw,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$start);   
    }
  
    $i = 1;
    $data = array();
    $user_id = session('SUPERADMIN_ID');
         
    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';
        $action .= '<li class="list-unstyled" style="margin: 0;"> ';
        if(permission($user_id,'29','action_edit')){
            $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/faqedit/' . Crypt::encrypt($row->id)) . '">
                    <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                </a>';
        }
        $action .= '   </li>';

        $action .= '<li class="list-unstyled " style="margin: 0;">';
        if(permission($user_id,'29','action_delete')){
            $action .= '<a href="' . asset('backend/faqdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                        <i class="fadeIn animated bx bx-trash anji me-0"></i>
                    </a>';
        }
        $action .= '</li>';
    
        $action .= '</ul>';

        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        $data[] = array(
            "id" => $row->id, 
            "question"=>$row->question,
    	    "answer"=>$row->answer,
            "status" => $status,
            "action" => $action
        );
    }
    
    $canViewGlobal = permission($user_id, '29', 'action_globle_view');
    $canAccessCity = permission($user_id, '29', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('faqs')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('faqs')->orderBy('id', 'ASC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('faqs')->where('user_id', $user_id)->orderBy('id', 'ASC');
    } else {
        $query = DB::table('faqs')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
        "draw" => $draw,
        "recordsTotal" => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data" => $data
    );
    
    echo json_encode($datas);
}

 function faqdelete($id)
    {
    $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '29', 'action_delete');
     if ($hasPermission) { 
      $id=Crypt::decrypt($id);
        $delete = Faq::find($id);
         $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','FAQ Delete','29','',$adduser,'','',$after,$before,''); 
     $message = fleshmessage(4,1,'FAQ');
          return redirect()->back()->with($message['status'],$message['message']);
     }
     $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
        
    }
          
      
    
    
      public function faqstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Faq::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'FAQ not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
    }   
    
    
    function faqedit(Request $request){
         $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '29', 'action_edit');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','FAQ View','29','','','','','','',''); 
    $id=Crypt::decrypt($request->id);
    
    $data['faq']= Faq::where('id',$id)->first();
    return view('backend.features.faqedit',$data);
    }
 $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
  
    }

    
    

     
}
