<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\File;
use App\Models\Contactenquiry;
use Crypt;
use Session;

class ContactController extends Controller
{
    function contact(){
          $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
     $user_id = session('SUPERADMIN_ID');
         $hasPermission = permission($user_id, '24', 'action_view');
     if ($hasPermission) {
          insertLogsAPI($user_id,'2','Contact View','24','','','','','','',''); 
            return view('backend.features.contact');
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
   
    }

    
     function contactajax(Request $request){
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $contactdata = Contactenquiry::contactajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $contactcount = Contactenquiry::contactajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $contact = Contactenquiry::contactajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $contactcount = Contactenquiry::contactajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($contactdata as $row) {
         $checkbox = '<input type="checkbox" class="row-checkbox" value="' . $row->id . '">';
    $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  
    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'24','action_delete')){
    $action .= '<a href="' . asset('backend/contactdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1">
                    <i class="fadeIn animated bx bx-trash anji me-0"></i>
                </a>';
      }
    $action .= '</li>';


    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
    $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
    </div>';

   
     $data[] = array(
    "id"        => $checkbox . " " . $row->id,
    "name" => $row->name,
    "number" => $row->number,
    "email" => $row->email,
    "message" => $row->message,
    "status" => $status,
    "action" => $action
    );
    }
    
    $canViewGlobal = permission($user_id, '24', 'action_globle_view');
    $canAccessCity = permission($user_id, '24', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
    $query = DB::table('contactenquiries')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('contactenquiries')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('contactenquiries')->where('user_id', $user_id)->orderBy('id', 'ASC');

    } else {
    $query = DB::table('contactenquiries')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }
  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $contactcount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }
        
        
        
    public function contactstatus(Request $request) {
    $id = $request->id;
    $statusstatus = Contactenquiry::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'Slider not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
}   





    public function contactdelete(Request $request, $id)
    {
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '24', 'action_delete');
        if ($hasPermission) { 
    $delete = Contactenquiry::findOrFail($id);


    $delete->delete();
    $after = json_encode($delete);
    $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Contact Delete','24','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Contact');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
    
    
     function deletemultiplecontact(Request $request)
{
    $ids = $request->ids;

    if (!empty($ids)) {
        $ids = array_filter($ids, function ($id) {
            return is_numeric($id);
        });

        if (!empty($ids)) {
            DB::table('contactenquiries')
                ->whereIn('id', $ids)
                ->delete();

            return response()->json([
                'status' => true,
                'message' => 'Selected records deleted successfully!'
            ]);
        }
    }

    return response()->json([
        'status' => false,
        'message' => 'No records selected!'
    ]);
}

    
}
