<?php

namespace App\Http\Controllers\backend\features;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use App\Models\Brand;
use App\Models\Service;
use App\Models\Tbl_Product;
use App\Models\tbl_blog;
use App\Models\Subservice;
use App\Models\Websitesetting;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\File;
use Crypt;
use Session;
class BlogController extends Controller
{
    function blog(){
    $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
     $user_id = session('SUPERADMIN_ID');
     $data['validateslug'] = array('editid'=> '','slugtype' => '1', 'fid'=>'19');

     $data['services'] = Service::where('status', '1')->get();
     $hasPermission = permission($user_id, '19', 'action_view');
     if ($hasPermission) { 
           insertLogsAPI($user_id,'2','Blog View','19','','','','','','',''); 
        return view('backend.features.blog' , $data);
     }
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
    }
    

    function blogedit(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '19', 'action_edit');
        if ($hasPermission) { 
        $id=Crypt::decrypt($request->id);
        $data['validateslug'] = array('editid'=> Crypt::decrypt($request->id),'slugtype' => '2', 'fid'=>'19');
        $data['services'] = Service::where('status', '1')->get();
        $data['blog']= tbl_blog::where('id',$id)->first();
        return view('backend.features.blogedit',$data);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }

    
    
    
    function blogcreate(Request $request){
    $user_id=session('SUPERADMIN_ID');
    $existingMobile = tbl_blog::where('slug', $request->slug)->first();
    $hasPermission = permission($user_id, '19', 'action_add');
    if ($hasPermission) { 
    if ($existingMobile) {
         $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }

        $create=new tbl_blog;
        $create->category = $request->category;
        $create->title = $request->title;
        $create->slug = $request->slug;
        $create->service_id = $request->service_id;
        $create->subservice_id = $request->subservice_id;
        $create->tagline = $request->tagline;
        $create->ordering_by = $request->ordering_by;
        $create->image_title = $request->image_title;
        $create->image_alt = $request->image_alt;
        $create->banner_title = $request->banner_title;
        $create->banner_alt = $request->banner_alt;
        $create->meta_tag = $request->meta_tag;
        $create->meta_title = $request->meta_title;
        $create->meta_keyword = $request->meta_keyword;
        $create->meta_description = $request->meta_description;
        $create->description = $request->description;


        if ($request->image) {
        $img = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/blogs'), $img);
        $create->image = $img;
        }
        if ($request->banner) {
        $img = time() . 'banner.' . $request->banner->extension();
        $request->banner->move(public_path('uploads/blogs'), $img);
        $create->banner = $img;
        }
        
        $create->user_id = $user_id;
        $create->created_by=$user_id;
        $create->panel_id='1';
        $create->tokan=reandum_code('50');
        $create->ip = CurrentTimestamp()['ip'];
        $create->strtotime = CurrentTimestamp()['strtotime'];
        $create->created_at = CurrentTimestamp()['datetime'];
        $create->updated_at = CurrentTimestamp()['datetime'];
        $create->save();
        $after = json_encode($create);
        $before = json_encode($create);
        $adduser=$create->id;
    insertLogsAPI($user_id,'1','Blog Add','19','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(2,1,'Blog');
    return redirect()->back()->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }   
    

    function blogupdate(Request $request){
    $id = Crypt::decrypt($request->id);
    $user_id = session('SUPERADMIN_ID');
    $hasPermission = permission($user_id, '19', 'action_edit');
    if ($hasPermission) { 
    $existingMobile = tbl_blog::where('slug', $request->slug)->where('id', '!=', $id)->first();
    if ($existingMobile) {
        $message = fleshmessage(6,1,'Slug');
        return redirect()->back()->with($message['status'],$message['message']);
    }
   
    $update = tbl_blog::findOrFail($id);
    $before = json_encode($update);
        $update->category = $request->category;
        $update->title = $request->title;
        $update->slug = $request->slug;
        $update->service_id = $request->service_id;
        $update->subservice_id = $request->subservice_id;
        $update->tagline = $request->tagline;
        $update->ordering_by = $request->ordering_by;
        $update->image_title = $request->image_title;
        $update->image_alt = $request->image_alt;
        $update->banner_title = $request->banner_title;
        $update->banner_alt = $request->banner_alt;
        $update->meta_tag = $request->meta_tag;
        $update->meta_title = $request->meta_title;
        $update->meta_keyword = $request->meta_keyword;
        $update->meta_description = $request->meta_description;
        $update->description = $request->description;

        if ($request->hasFile('image')) {
        if ($update->image && file_exists(public_path('uploads/blogs/' . $update->image))) {
            unlink(public_path('uploads/blogs/' . $update->image));
        }

        $imgName = time() . 'image.' . $request->image->extension();
        $request->image->move(public_path('uploads/blogs'), $imgName);
        $update->image = $imgName;
        }
        if ($request->hasFile('banner')) {
        if ($update->banner && file_exists(public_path('uploads/blogs/' . $update->banner))) {
            unlink(public_path('uploads/blogs/' . $update->banner));
        }

        $imgName = time() . 'banner.' . $request->banner->extension();
        $request->banner->move(public_path('uploads/blogs'), $imgName);
        $update->banner = $imgName;
        }
        
        $update->user_id = $user_id;
        $update->created_by=$user_id;
        $update->panel_id='1';
        $update->ip = CurrentTimestamp()['ip'];
        $update->strtotime = CurrentTimestamp()['strtotime'];
        $update->created_at = CurrentTimestamp()['datetime'];
        $update->updated_at = CurrentTimestamp()['datetime'];

    $update->save();
    $after = json_encode($update);
    $adduser=$update->id;
    insertLogsAPI($user_id,'3','Blog Update','19','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(3,1,'Blog');
    return redirect(url('backend/features/blog'))->with($message['status'],$message['message']);
    }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }        
    
    

    function blogajax(Request $request){
    $draw   = $request->draw ?? 0;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex = $request->order[0]['column'] ?? 0;
    $columnName  = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue = $request->search['value'] ?? null;
    
    $user_id = session('SUPERADMIN_ID');
    if($user_id=='1'){
   

    $blogdata = tbl_blog::blogajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $blogcount = tbl_blog::blogajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
    $blogdata = tbl_blog::blogajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $blogcount = tbl_blog::blogajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
     
    $i = 1;
    $data = array();
    $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($blogdata as $row) {
    $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';  

    // Edit Button
    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
    if(permission($user_id,'19','action_edit')){
        $action .= '   <a class="btn actionedit editbtn btn-sm " href="' . asset('backend/blogedit/' . Crypt::encrypt($row->id)) . '"><i class="fadeIn animated bx bx-pencil anji me-0"></i></a>';
    }
    $action .= '   </li>';
              
    $action .= '<li class="list-unstyled">';
      if(permission($user_id,'19','action_delete')){
    $action .= '<a href="' . asset('backend/blogdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-1"><i class="fadeIn animated bx bx-trash anji me-0"></i></a>';
    }
    $action .= '</li>';

    $action .= '</ul>';
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
    $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
    </div>';
         $subservice = Subservice::where('id',$row->subservice_id)->first();
         if(empty($subservice)){
        $subservice = "";
    }else{
        $subservice = $subservice->title;
    } 
     $Subservice = '<span>'.$subservice.'</span>'; 
     
  $service = Service::where('id',$row->service_id)->first();
         if(empty($service)){
        $service = "";
    }else{
        $service = $service->title;
    } 
     $Services = '<span>'.$service.'</span>';
     
     $data[] = array(
    "id" => $row->id,
    "ordering_by" => $row->ordering_by,
    "service" => 
    '<span class="badge servicecolor" style="background:#5D3FD3;">' . $Services . '</span><br>' .
    '<span class="badge subservicecolor" style="background:#E91E63;">' . $Subservice . '</span>',
    "title" => $row->title,
    "image" => '<a href="' . asset('uploads/blogs/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/blogs/' . $row->image) . '" style=" width: 36px;"></a>',
    "status" => $status,
    "action" => $action
    );
    }
    
    $canViewGlobal = permission($user_id, '19', 'action_globle_view');
    $canAccessCity = permission($user_id, '19', 'action_globle_city');

    $city = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($user_id == '1') {
        $query = DB::table('tbl_blogs')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('tbl_blogs')->orderBy('id', 'ASC');

    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('tbl_blogs')->where('user_id', $user_id)->orderBy('id', 'ASC');

    } else {
        $query = DB::table('tbl_blogs')->where('user_id', $user_id)->orderBy('id', 'ASC');
    }

    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $blogcount,
    "data" => $data
    );
    
    echo json_encode($datas);
    }
    
    
    public function blogstatus(Request $request) {
    $id = $request->id;
    $statusstatus = tbl_blog::find($id);
    if (!$statusstatus) {
        return response()->json(['success' => false, 'message' => 'blog not found'], 404);
    }

    $statusstatus->status = $request->status;
    $statusstatus->save();
    return response()->json(['success' => true]);
    }    
    
    public function blogdelete(Request $request, $id)
    {
    $user_id = session('SUPERADMIN_ID');
    $id = Crypt::decrypt($id);
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '19', 'action_delete');
        if ($hasPermission) { 
    $delete = tbl_blog::findOrFail($id);
    if ($delete->image) {
        $logoPath = public_path('uploads/blogs/' . $delete->image);
        if (file_exists($logoPath)) {
            @unlink($logoPath);
        }
    }
    if ($delete->banner) {
        $bannerPath = public_path('uploads/blogs/' . $delete->banner);
        if (file_exists($bannerPath)) {
            @unlink($bannerPath);
        }
    }

    $delete->delete();
    $after = json_encode($delete);
    $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Blog Delete','19','',$adduser,'','',$after,$before,''); 
    $message = fleshmessage(4,1,'Blog');
    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }
}
