<?php

namespace App\Http\Controllers\backend\email;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\tbl_email_tmp;
use App\Models\superadmin;
use DB;
use App\Models\Websitesetting;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\File;

class EmailtemplateController extends Controller
{
    function emailtemplate(){
         $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
     $user_id = session('SUPERADMIN_ID');
        
     $hasPermission = permission($user_id, '7', 'action_view');
     if ($hasPermission) { 
        return view('backend.email.emailtemplate');
     }
     
     $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }
    
    
    
    function emailtemplatepage(Request $request){
        
           $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
        $id=Crypt::decrypt($request->id);
        $data['templatecontent']=tbl_email_tmp::where('id',$id)->first();
        return view('backend.email.emailtemplatepage',$data);
    }
    

 function emailtemplateadd(Request $request){
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '7', 'action_add');
        if ($hasPermission) { 
    $create = new tbl_email_tmp;
    $create->title = $request->title;
    $create->user_id = $user_id;
    $create->subject = $request->subject;
    $create->content = $request->content;
    $create->tokan = reandum_code(50);
    $create->ip=CurrentTimestamp()['ip'];  
    $create->strtotime=CurrentTimestamp()['strtotime'];
    $create->save();
    $after = json_encode($create);
     $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Email Template Add','7','',$adduser,'','',$after,$before); 
    $message = fleshmessage(2,1,'Email Template');

    return redirect()->back()->with($message['status'],$message['message']);
}
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
    }

public function emailtemplateupdate(Request $request)
{
      $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '7', 'action_edit');
        if ($hasPermission) { 
    $template = tbl_email_tmp::where('id',$request->id)->first();
     $before = json_encode($template);
    $template->title = $request->title;
    $template->user_id = $user_id;
    $template->subject = $request->subject;
    $template->content = $request->content;
    $template->ip=CurrentTimestamp()['ip'];
    $template->strtotime=CurrentTimestamp()['strtotime'];
    $template->save();
    
    $after = json_encode($template);
 $adduser=$template->id;
    insertLogsAPI($user_id,'3','Email Template Update','7','',$adduser,'','',$after,$before); 
 $message = fleshmessage(3,1,'Email Template');

    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
}


    

    function emailtemplateviewajax(Request $request){
  $draw   = $request->draw ?? 1;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;

   
    $columnIndex        = $request->order[0]['column'] ?? 0;
    $columnName         = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder    = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue        = $request->search['value'] ?? null;
    
     $user_id = session('SUPERADMIN_ID');
    $roledata = superadmin::where('id', $user_id)->first();
    if($roledata->role=='1'){

    $emailtemplatedata = tbl_email_tmp::emailtemplateviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1);
   $emailtemplatecount = tbl_email_tmp::emailtemplateviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0);
    }else{
    $emailtemplatedata = tbl_email_tmp::emailtemplateviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$user_id);
   $emailtemplatecount = tbl_email_tmp::emailtemplateviewajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$user_id);
    }
   
    
    $i = 1;
    $data = array();
    foreach ($emailtemplatedata as $row) {
    $action = '<ul class="action list-unstyled d-flex m-0" >';
      if(permission($user_id,'7','action_edit')){
     $action .= '<li class="list-unstyled" style="margin: 0;">
            <a data-bs-toggle="modal" 
               data-bs-target="#editModal" 
               class="actionedit btn editbtn btn-sm" 
               href="javascript:void(0);" 
               onClick="emailtemplateedit(' . htmlspecialchars(json_encode($row), ENT_QUOTES, 'UTF-8') . ');">
                <i class="fadeIn animated anji bx bx-pencil me-0"></i>
            </a>';
      }
       $action .= '   </li>';

      if(permission($user_id,'7','action_delete')){
    $action .= '<li><a  class="btn deletebtn btn-sm ms-2" onclick="return check_delete();" href="' . asset('backend/emailtemplatedelete/'.Crypt::encrypt($row->id)) . '"><i class="fadeIn animated bx bx-trash anji me-0"></i>
    </a>';
    }
  $action .= '   </li>';

  if(permission($user_id,'7','action_view')){
$action .= '<li>

    <a class="btn btn-sm btn-info rounded-circle d-flex align-items-center justify-content-center ms-2" 
       title="View Details" 
       style="width: 32px; height: 32px;" 
       href="' . asset('backend/emailtemplatepage/' . Crypt::encrypt($row->id)) . '">
        <i class="bx bx-show anji text-white me-0" style="margin-top: -16px !important;"></i>
    </a>';
    }
   $action .= ' </li>';

    $action .= '</ul>';
    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
     
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';
    
     $data[] = array(
    	"id"=> $row->id,
    	"title"=>$row->title,
    	"subject"=>$row->subject,
    // 	"content"=>$row->content,
    	"status"=> $status,
    	"action" => $action,
    	);
    
    }

   $canViewGlobal = permission($user_id, '7', 'action_globle_view');
$canAccessCity = permission($user_id, '7', 'action_globle_city');

$city = superadmin::where('id', $user_id)->first();
$globle = $city->global_city ?? 0;

if ($roledata->role == '1') {
    $query = DB::table('tbl_email_tmps')->orderBy('id', 'DESC');

} elseif ($globle == 1 && $canViewGlobal) {
    $query = DB::table('tbl_email_tmps')->orderBy('id', 'DESC');

} elseif ($globle == 1 && $canAccessCity) {
    $query = DB::table('tbl_email_tmps')->where('id', $user_id)->orderBy('id', 'DESC');

} else {
    $query = DB::table('tbl_email_tmps')->where('id', $user_id)->orderBy('id', 'DESC');
}
     
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $emailtemplatecount,
    "data" => $data
    );
    
    echo json_encode($datas);
}


  public function emailtemplatestatus(Request $request) {
    $id = $request->id;
    $status = tbl_email_tmp::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => ' Email Template   not found'], 404);
    }
    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}




function emailtemplatedelete(Request $request,$id){
      $id=Crypt::decrypt($id);
       $user_id = session('SUPERADMIN_ID');
      $hasPermission = permission($user_id, '7', 'action_delete');
        if ($hasPermission) { 
        $delete = tbl_email_tmp::findOrFail($id);
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Admin User Add','7','',$adduser,'','',$after,$before); 
        
      $message = fleshmessage(4,1,'Email Template');

    return redirect()->back()->with($message['status'],$message['message']);
        }
    $website = Websitesetting::where('id', '1')->first();
    $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
    return redirect(asset('backend/permission_denied'))
        ->with($messagepremission['status'], $messagepremission['message'])
        ->send();
        
    }
}
