<?php

namespace App\Http\Controllers\backend\adminuser;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\superadmin;
use App\Models\tbl_message_api;
use App\Models\tbl_admin_otpverify;
use App\Models\Websitesetting;

use Validator,Redirect,Response;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use Illuminate\Support\Facades\File;

// use App\Mail\mail;
use Illuminate\Support\Facades\Mail;
use App\Mail\AdminEmailverify;
use Illuminate\Support\Facades\Http;
use Jenssegers\Agent\Agent;
use App\Models\Role;
use App\Models\tbl_crud_feature;
use App\Models\tbl_permission;
use Illuminate\Support\Facades\Hash;
use Crypt;
use Session;
class AdminuserController extends Controller
{
    //
    
    
     //Role//
public function role()
{
     $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
    
    $user_id = session('SUPERADMIN_ID');
      insertLogsAPI($user_id,'2','Role View','3','','','','','','',''); 
    $hasPermission = permission($user_id, '3', 'action_view');
    if (!$hasPermission) {
         $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }


    return view('backend.role.role');
}



      
    
  
    
  function rolecreate(Request $request) {
  $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '3', 'action_add');
     if ($hasPermission) { 
           $existingRole = Role::where('role', $request->title)->first();
    if ($existingRole) {
        return redirect()->back()->with('error', 'Role already exists!');
    }
    
    $role = new Role;
    $role->role = $request->title;
    $role->ip = CurrentTimestamp()['ip'];
    $role->strtotime = CurrentTimestamp()['strtotime'];
    $role->save();
   $adduser=  $role->id;
    $after = json_encode($role);
    $before = json_encode($role);
    insertLogsAPI($user_id,'1','Role Add','3','',$adduser,'','',$after,$before,''); 
     $message = fleshmessage(2,1,'Role');
    return redirect()->back()->with($message['status'],$message['message']);
         
     }
       $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
         
  
}


function roleajax(Request $request){
    $draw= $request->draw;
    $rows = $request->start;
    $columnIndex = $request->order[0]['column'];
    $columnName = $request->columns[$columnIndex]['data'];
    $columnSortOrder = $request->order[0]['dir'];
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'];
    $searchValue = $request->search['value'];
    $length = $request->length;


 $user_id = session('SUPERADMIN_ID');
  $roledata = superadmin::where('id', $user_id)->first();
    if($roledata->role=='1'){
   

    $housesurveydata = Role::roleajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length);
    $housesurveycount = Role::roleajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length);
    }else{
       $housesurveydata = Role::roleajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,1,$length,$user_id);
    $housesurveycount = Role::roleajax($rows,$searchValue,$columnSortOrder,$columnName,$columnIndex,$filltersearchValue,0,$length,$user_id);   
    }
  
  
    $i = 1;
    $data = array();
      $user_id=session('SUPERADMIN_ID');
         
     
    foreach ($housesurveydata as $row) {
   $action = '<ul class="action d-flex  m-0" style="list-style-type: none; ">';  

    $action .= '<li class="list-unstyled" style="margin: 0;"> ';
   if(permission($user_id,'3','action_edit')){
                  $action .= '<a href="javascript:void(0);" 
                   onClick="categoryupdate(' . $row->id . ', \'' . $row->role . '\');" 
                   class="btn editbtn btn-sm">
                    <i class="fadeIn animated anji bx bx-pencil me-0"></i>
                </a>';
                    }
  
              $action .= '   </li>';



   

  



    $action .= '</ul>';




    
    if($row->status === '1'){ 
    $checked = 'checked'; 
    }
    
   $status = '<div class="toggle-flip" style="margin-left: 4px;">
    <input
        type="checkbox"
        id="flip' . $row->id . '"
        name="status"
        class="status-toggle"
        data-id="' . $row->id . '"
        onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
    <label class="flip-label" for="flip' . $row->id . '"></label>
</div>';

 
   
     $data[] = array(
    "id" => $row->id, 
   "role" => $row->role,
   "status" => $status,
    "action" => $action
);

    
    }
    
$query = DB::table('roles')->orderBy('id', 'ASC');
  $canViewGlobal = permission($user_id, '3', 'action_globle_view');
$roledata = superadmin::where('id', $user_id)->first();

 if ($roledata->role == '1') {
    $query = DB::table('roles')->orderBy('id', 'ASC');

} elseif ( $canViewGlobal) {
    $query = DB::table('roles')->orderBy('id', 'ASC');

} elseif ($roledata->role) {
        $query = DB::table('roles')->orderBy('id', 'ASC')->where('id',$roledata->role);
    }






  
    $tot_rows = $query->count();
    
    $datas = array(
    "draw" => $draw,
    "recordsTotal" => $tot_rows,
    "recordsFiltered" => $housesurveycount,
    "data" => $data
    );
    
    echo json_encode($datas);

    
    }

    
  function roleedit(Request $request) {
      
        $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '3', 'action_edit');
     if ($hasPermission) { 
               
    $existingRole = Role::where('role', $request->title)->where('id', '!=', $request->id) ->first();

    if ($existingRole) {
        return redirect()->back()->with('error', 'Role already exists!');
    }

    $roleedit = Role::where('id', $request->id)->first();
    $before = json_encode($roleedit);
    if (!$roleedit) {
        return redirect()->back()->with('error', 'Role not found!');
    }

    $roleedit->role = $request->title;
    $roleedit->ip = CurrentTimestamp()['ip'];
    $roleedit->strtotime = CurrentTimestamp()['strtotime'];
    $roleedit->save();
    $adduser=  $roleedit->id;
    $after = json_encode($roleedit);
    
    insertLogsAPI($user_id,'3','Role Update','3','',$adduser,'','',$after,$before,''); 
     $message = fleshmessage(3,1,'Role');
    return redirect()->back()->with($message['status'],$message['message']);

         
     }
      $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();

}

    
    
    public function rolestatus(Request $request) {
    $id = $request->id;
    $rolestatus = Role::find($id);
    if (!$rolestatus) {
        return response()->json(['success' => false, 'message' => 'Role not found'], 404);
    }

    $rolestatus->status = $request->status;
    $rolestatus->save();
    return response()->json(['success' => true]);
}

      function roledelete($id)
    {
          $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '3', 'action_delete');
     if ($hasPermission) { 
          $categorydel = Role::where('id', Crypt::decrypt($id))->delete();
        return redirect()->back()->with('success','Role Delete Successfully');
     }
        $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
       
    }
    
    
   
    public function permission_denied(){
          $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
     $user_id = session('SUPERADMIN_ID');
     insertLogsAPI($user_id,'2','Permission Denied','','','','','','','',''); 
    
         return view('backend.adminuser.permission_denied');
     }
    
    
    //Admin User

    function adminuser(){
         $loginRedirect = sessionlogin();
    if ($loginRedirect) {
        return $loginRedirect; 
    }
        $user_id = session('SUPERADMIN_ID');
        
     $hasPermission = permission($user_id, '4', 'action_view');
     if ($hasPermission) { 
         $data['roles']=Role::where('status','1')->get();
           insertLogsAPI($user_id,'3','Admin User View','4','','','','','','',''); 
         return view('backend.adminuser.adminuser',$data);
     }
       $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
      
    }
    function adminuseradd(){
        $user_id = session('SUPERADMIN_ID');
        
     $hasPermission = permission($user_id, '4', 'action_add');
     if ($hasPermission) { 
        $data['role']=Role::where('status','1')->get();
          $data['feature'] = tbl_crud_feature::get();
           $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
        return view('backend.adminuser.adminuseradd',$data);
     }
     $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }
    
    function imagecheck(Request $request) {
          $allowedExtensions = ['image/jpeg', 'image/png', 'image/webp'];
        $fileType = $request->input('fileType');
        if (in_array($fileType, $allowedExtensions)) {
            return response()->json(['success' => true]);
            } else { return response()->json(['success' => false]); }
            }
            
            
    function adminusercreate(Request $request){
        $user_id = session('SUPERADMIN_ID');
        $hasPermission = permission($user_id, '4', 'action_add');
     if ($hasPermission) { 
           $existingMobile = superadmin::where('mobile', $request->number)->first();
    if ($existingMobile) {
        return redirect()->back()->with('error', 'Mobile number already exists!');
    }

  
    $existingEmail = superadmin::where('email', $request->email)->first();
    if ($existingEmail) {
        return redirect()->back()->with('error', 'Email  already exists!');
    }
    
    
        $create = new superadmin;
    $create->firstname = $request->f_name;
    $create->lastname = $request->l_name;
    $create->mobile= $request->number;
   $create->password = Hash::make($request->password);
      $create->countries = $request->countries;
      $create->state = $request->state;
      $create->city = $request->city;
      $create->pincode = $request->pincode;
        $create->email_verified = '1';
      $create->mobile_verified = '1';
      $create->verift_status = '1';
      $create->address = $request->address;
      $create->token = reandum_code('50');
     $create->username = $request->f_name . $request->l_name;

      $create->role = $request->role;
    $create->email = $request->email;

   

    if ($request->image) {
        $img = time().'.'.$request->image->extension();
        $request->image->move(public_path('uploads/adminuser'), $img);
        $create->image = $img;
    }
    if ($request->idproof) {
        $img = time().'.'.$request->idproof->extension();
        $request->idproof->move(public_path('uploads/adminuser'), $img);
        $create->idproof = $img;
    }

 $create->global_city = $request->global_city;
 $create->description = $request->description;
   
    $create->ip = $_SERVER['REMOTE_ADDR'];
    // $create->strtotime = strtotime(date('d-m-Y'));
  
    $create->save();
     $after = json_encode($create);
     $before = json_encode($create);
    $adduser=$create->id;
    insertLogsAPI($user_id,'1','Admin User Add','4','',$adduser,'','',$after,$before,''); 

 foreach ($request->feature as $index => $featuredData) {
        $feature = new tbl_permission();
        $feature->feature_id = $featuredData;
        $feature->action_view = isset($request->viewOwnHidden[$index]) ? $request->viewOwnHidden[$index] : 0;
        $feature->action_add = isset($request->addHidden[$index]) ? $request->addHidden[$index] : 0;
        $feature->action_globle_city = isset($request->cityHidden[$index]) ? $request->cityHidden[$index] : 0;
        $feature->action_globle_view = isset($request->viewgHidden[$index]) ? $request->viewgHidden[$index] : 0;
        $feature->action_edit = isset($request->editHidden[$index]) ? $request->editHidden[$index] : 0;
        $feature->action_delete = isset($request->deleteHidden[$index]) ? $request->deleteHidden[$index] : 0;
        $feature->user_id = $create->id;
      
        $feature->ip = $_SERVER['REMOTE_ADDR'];
        $feature->strtotime = strtotime(date('d-m-Y'));
        $feature->save();
    }
    
    $message = fleshmessage(2,1,'Admin User');

    return redirect(asset('backend/adminuser'))->with($message['status'],$message['message']);
     }
     $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }  
    
    public function houseajexadminuser(Request $request)
{
    $filterData = [
        'role'        => $request->role,
        'emailmobile' => $request->emailmobile,
    ];

    $draw   = $request->draw ?? 1;
    $rows   = $request->start ?? 0;
    $length = $request->length ?? 10;


    $columnIndex     = $request->order[0]['column'] ?? 0;
    $columnName      = $request->columns[$columnIndex]['data'] ?? 'id';
    $columnSortOrder = $request->order[0]['dir'] ?? 'asc';
    $filltersearchValue = $request->columns[$columnIndex]['search']['value'] ?? null;
    $searchValue     = $request->search['value'] ?? null;

    $user_id  = session('SUPERADMIN_ID');
    $roledata = superadmin::where('id', $user_id)->first();

    if ($roledata->role == '1') {
        $housesurveydata  = superadmin::houseajexadminuser($rows, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, 1, $length, $filterData);
        $housesurveycount = superadmin::houseajexadminuser($rows, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, 0, $length, $filterData);
    } else {
        $housesurveydata  = superadmin::houseajexadminuser($rows, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, 1, $length, $user_id, $filterData);
        $housesurveycount = superadmin::houseajexadminuser($rows, $searchValue, $columnSortOrder, $columnName, $columnIndex, $filltersearchValue, 0, $length, $user_id, $filterData);
    }

    $data    = [];
    $user_id = session('SUPERADMIN_ID');

    foreach ($housesurveydata as $row) {
        $action = '<ul class="action d-flex m-0 " style="list-style-type: none; ">';

        // Edit Button
        $action .= '<li class="list-unstyled" style="margin: 0;">';
        if (permission($user_id, '4', 'action_edit')) {
            $action .= '<a class="btn actionedit editbtn btn-sm" href="' . asset('backend/adminuseredit/' . Crypt::encrypt($row->id)) . '">
                            <i class="fadeIn animated bx bx-pencil anji me-0"></i>
                        </a>';
        }
        $action .= '</li>';

        // Delete Button
        if ($row->id != '1') {
            $action .= '<li class="list-unstyled">';
            if (permission($user_id, '4', 'action_delete')) {
                $action .= '<a href="' . asset('backend/adminuserdelete/' . Crypt::encrypt($row->id)) . '" onclick="return check_delete()" class="btn deletebtn btn-sm ms-2">
                                <i class="fadeIn animated bx bx-trash anji me-0"></i>
                            </a>';
            }
            $action .= '</li>';
        }
        $action .= '</ul>';

    
        $status = '<div class="toggle-flip" style="margin-left: 4px;">
            <input
                type="checkbox"
                id="flip' . $row->id . '"
                name="status"
                class="status-toggle"
                data-id="' . $row->id . '"
                onclick="round_success_noti()" ' . ($row->status == 1 ? 'checked' : '') . '>
            <label class="flip-label" for="flip' . $row->id . '"></label>
        </div>';

        // Role
        $role = Role::where('id', $row->role)->first();
        $roleName = $role->role ?? '';

        $data[] = [
            "id"    => $row->id,
            "image" => '<a href="' . asset('uploads/adminuser/' . $row->image) . '" data-fancybox="images" data-caption=""><img src="' . asset('uploads/adminuser/' . $row->image) . '" style="width: 30px;"></a>',
            "role"  => '<span>' . $roleName . '</span>',
            "name"  => $row->firstname . ' ' . $row->lastname,
            "number"=> $row->mobile,
            "email" => $row->email,
            "status"=> $status,
            "action"=> $action,
        ];
    }

    // Total Records Calculation
    $canViewGlobal = permission($user_id, '4', 'action_globle_view');
    $canAccessCity = permission($user_id, '4', 'action_globle_city');

    $city   = superadmin::where('id', $user_id)->first();
    $globle = $city->global_city ?? 0;

    if ($roledata->role == '1') {
        $query = DB::table('superadmins')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canViewGlobal) {
        $query = DB::table('superadmins')->orderBy('id', 'DESC');
    } elseif ($globle == 1 && $canAccessCity) {
        $query = DB::table('superadmins')->where('id', $user_id)->orderBy('id', 'DESC');
    } else {
        $query = DB::table('superadmins')->where('id', $user_id)->orderBy('id', 'DESC');
    }

    $tot_rows = $query->count();

    $datas = [
        "draw"            => intval($draw),
        "recordsTotal"    => $tot_rows,
        "recordsFiltered" => $housesurveycount,
        "data"            => $data,
    ];

    return response()->json($datas);
}

    
    

 public function adminuserstatus(Request $request) {
    $id = $request->id;
    $status = superadmin::find($id);

    if (!$status) {
        return response()->json(['success' => false, 'message' => 'Admin User not found'], 404);
    }

    $status->status = $request->status;
    $status->save();

    return response()->json(['success' => true]);
}



 function adminuserdelete(Request $request,$id){
     
        $user_id = session('SUPERADMIN_ID');
    
     $hasPermission = permission($user_id, '4', 'action_delete');
     if ($hasPermission) {
      $id=Crypt::decrypt($id);
   
        $delete = superadmin::findOrFail($id);
      $image_path = public_path("uploads/adminuser/{$delete->image}");
      $idproof_path = public_path("uploads/adminuser/{$delete->idproof}");
         if (File::exists($image_path) && !File::isDirectory($image_path)) {
           
            unlink($image_path);
        }
         if (File::exists($idproof_path) && !File::isDirectory($idproof_path)) {
           
            unlink($idproof_path);
        }
        $delete->delete();
        $after = json_encode($delete);
     $before = json_encode($delete);
    $adduser=$delete->id;
    insertLogsAPI($user_id,'4','Admin User Delete','4','',$adduser,'','',$after,$before,''); 
        
      $message = fleshmessage(4,1,'Admin User');
          return redirect()->back()->with($message['status'],$message['message']);
       
     }
     
       $website=Websitesetting::where('id','1')->first();
      $messagepremission = fleshmessage(5,2,'Permission Denied',$website->mobile_number);
      return redirect(asset('backend/permission_denied'))->with($messagepremission['status'],$messagepremission['message']) ->send();
     
        
    }
    
    function adminuseredit(Request $request){
        $id=Crypt::decrypt($request->id);
        $user_id = session('SUPERADMIN_ID');
        
     $hasPermission = permission($user_id, '4', 'action_edit');
     if ($hasPermission) { 
       
        $data['adminuserdata']=superadmin::where('id',$id)->first();
         $data['role']=Role::get();
             $data['country'] = DB::table('tbl_countries')->where('cstatus','1')->get();
         $data['feature'] = tbl_crud_feature::get();
        return view('backend.adminuser.adminuseredit',$data);
     }
     $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
    }
    
    
    public function adminuserupdate(Request $request)
{
    $user_id = session('SUPERADMIN_ID');
     $hasPermission = permission($user_id, '4', 'action_edit');
     if ($hasPermission) { 
    try {
        $id = Crypt::decrypt($request->id);

        $existingMobile = superadmin::where('mobile', $request->number)->where('id', '!=', $id)->first();
        if ($existingMobile) {
            return redirect()->back()->with('error', 'Mobile number already exists!');
        }

        $existingEmail = superadmin::where('email', $request->email)->where('id', '!=', $id)->first();
        if ($existingEmail) {
            return redirect()->back()->with('error', 'Email already exists!');
        }

        $update = superadmin::findOrFail($id);
        $before = json_encode($update);
        $update->firstname = $request->f_name;
        $update->lastname = $request->l_name;
        $update->mobile  = $request->number;
        $update->role = $request->role;
          $update->countries = $request->countries;
      $update->state = $request->state;
      $update->email_verified = '1';
      $update->mobile_verified = '1';
      $update->verift_status = '1';
      $update->city = $request->city;
      $update->pincode = $request->pincode;
       $update->global_city = $request->global_city;
      $update->address = $request->address;
        $update->email = $request->email;
        $update->ip = $_SERVER['REMOTE_ADDR'];
        // $update->strtotime = strtotime(date('d-m-Y'));

        if ($request->hasFile('image')) {
            $img = time() . '.' . $request->image->extension();
            $request->image->move(public_path('uploads/adminuser'), $img);
            $update->image = $img;
        }

        if ($request->hasFile('idproof')) {
            $img = time() . '_id.' . $request->idproof->extension();
            $request->idproof->move(public_path('uploads/adminuser'), $img);
            $update->idproof = $img;
        }

        $update->save();
        $after = json_encode($update);
         $adduser=$update->id;
    insertLogsAPI($user_id,'3','Admin User Update','4','',$adduser,'','',$after,$before,''); 

        // Update Permissions
        foreach ($request->feature as $index => $featuredData) {
            $feature = tbl_permission::where('user_id', $id)
                                     ->where('feature_id', $featuredData)
                                     ->first();

            if (!$feature) {
                $feature = new tbl_permission();
                $feature->user_id = $id;
                $feature->feature_id = $featuredData;
            }

            $feature->action_view        = $request->viewOwnHidden[$index] ?? 0;
            $feature->action_globle_view = $request->viewgHidden[$index] ?? 0;
            $feature->action_globle_city = $request->cityHidden[$index] ?? 0;
            $feature->action_add         = $request->addHidden[$index] ?? 0;
            $feature->action_edit        = $request->editHidden[$index] ?? 0;
            $feature->action_delete      = $request->deleteHidden[$index] ?? 0;
            $feature->ip = $_SERVER['REMOTE_ADDR'];
            $feature->strtotime = strtotime(date('d-m-Y'));
            $feature->save();
        }

$message = fleshmessage(3,1,'Admin User');
        return redirect(asset('backend/adminuser'))->with($message['status'],$message['message']);
    } catch (\Exception $e) {
        return redirect()->back()->with('error', 'Something went wrong: ' . $e->getMessage());
    }
     }
     $website = Websitesetting::where('id', '1')->first();
         $messagepremission = fleshmessage(5, 2, 'Permission Denied', $website->mobile_number);
       return redirect(asset('backend/permission_denied'))->with($messagepremission['status'], $messagepremission['message'])->send();
}


   
}
