<?php
use Illuminate\Support\Facades\Cookie;
use App\Models\Service;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Request;
use App\Models\Subservice;

use App\Models\Serviceallottedcity;
use App\Models\Tbl_Product;
use App\Models\ChildService;
use App\Models\ServicePlan;

function pagesmetadata($url){
    return  DB::table('pages')->where('page_url',$url)->first();
}



function insertLogsAPIuser($user_id, $activity = "", $function = "", $primary_id = "", $description = "", $from = null, $after = "", $before = "", $feature_id = null)
{
    // Current URL
    $actual_link = (request()->secure() ? 'https' : 'http') . "://" . request()->getHttpHost() . request()->getRequestUri();

    $data = [
        'ip'             => CurrentTimestamp()['ip'],
        'user_id'        => $user_id,
        'date_time'      => CurrentTimestamp()['datetime'],
        'strtotime'      => CurrentTimestamp()['strtotime'],
        'activity_id'    => $activity,
        'curd_functions' => $function,
        'web_url'        => $actual_link,
        'table_primary_id' => $primary_id !== '' ? $primary_id : null,
        'read_status'    => 0,
        'description'    => $description,
        'created_at'     => CurrentTimestamp()['datetime'],
        'updated_at'     => CurrentTimestamp()['datetime'],
        'after'          => $after,
        'before'         => $before,
    ];

    // Safe check for last record
    if ($activity == '2') {
        $lastdata = DB::table('user_logs')->orderBy('id', 'DESC')->first();

    if ($lastdata && $lastdata->activity_id == $activity && $lastdata->feature_id == $feature_id) {
            return true; // skip insert
    } else {
            $inserted = DB::table('user_logs')->insert($data);
    }
    
    } else {
        $inserted = DB::table('user_logs')->insert($data);
    }
        return !empty($inserted);
}


     function getServiceAndSubservice($service_id, $subservice_id){
        $cityid = cookiescity();

        $service = Serviceallottedcity::join('services', 'services.id', '=', 'serviceallottedcities.serviceid')
            ->where('services.id', $service_id)
            ->where('services.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '1')
            ->first();

        $subservice = Serviceallottedcity::join('subservices', 'subservices.id', '=', 'serviceallottedcities.serviceid')
            ->where('subservices.id', $subservice_id)
            ->where('subservices.status', '1')
            ->where('serviceallottedcities.city_id', $cityid)
            ->where('serviceallottedcities.status', '1')
            ->where('serviceallottedcities.service_type', '2')
            ->first();

        return [
            'service' => $service,
            'subservice' => $subservice
        ];
    }

  if (!function_exists('getServicesMegaMenu')) {
        function getServicesMegaMenu()
        {
            return Service::select('services.id', 'services.title')
                ->where('services.status', '1')
                ->where('services.status', '1')
                ->with(['subservices'])
                ->get();
        }
    }
