<?php echo $__env->make('backend/include/custom', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<!doctype html>
<html lang="en" class="color-sidebar sidebarcolor7 color-header headercolor8">

<head>

<!--favicon-->

<?php echo $__env->make('backend/include/head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend/include/datatableajax/tablelink', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<title>Reminder Update</title>
</head>

<body>
<!--wrapper-->
<div class="wrapper">
<!--sidebar wrapper -->
<?php echo $__env->make('backend/include/sidebar', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
<!--end sidebar wrapper -->
<!--start header -->
<?php echo $__env->make('backend/include/header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	
<!--end header -->



<div class="page-wrapper">
<div class="page-breadcrumb d-flex justify-content-between mt-3 main_header card p-1">
    <div class="breadcrumb-title d-flex align-items-center ms-3 " >
        <i class="bx bx-carousel me-1"></i>
        <span class="">Reminder Update</span>
    </div>
</div>

 
<div class="page-content">
   <div class="row">
					<div class="col-xl-12 mx-auto">
      <div class="card">
        <div class="card-body">
  <form class="row g-3 needs-validation" onsubmit="return myckediter()" id="formatDistrict-update" method="POST" action="<?php echo e(asset('backend/reminderupdate/' . Crypt::encrypt($reminderdata->id))); ?>" enctype="multipart/form-data" novalidate>
    <?php echo csrf_field(); ?>
    <section class="mb-4">
      <div class="row">

         <div class="col-md-6">
            <label for="reminder_type" class="form-label">Reminder Type <span class="text-danger">*</span></label>
            <select name="reminder_type" class="form-select" id="reminder_type" required>
              <option value="">Select Reminder</option>

    <?php $__currentLoopData = $remindertype; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reminderType): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<option value="<?php echo e($reminderType->id); ?>" <?php echo e($reminderdata->reminder_type == $reminderType->id ? 'selected' : ''); ?>>
    <?php echo e($reminderType->title); ?>

</option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <!-- File Upload -->

<div class="col-md-6 mb-3">
  <label for="file" class="form-label">
    File <span class="text-danger">*(JPG, PNG, WEBP)</span>
  </label>

  <div class="input-group">
    <input 
      type="file"
      data-value="imageerror1"
      class="form-control image <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
      id="file"
      name="file"
      accept=".jpg,.jpeg,.png,.webp"
    >

    <?php if(!empty($reminderdata->file)): ?>
      <a href="<?php echo e(asset('uploads/reminder/' . $reminderdata->file)); ?>"
         data-fancybox="image"
         data-caption="">
        <img src="<?php echo e(asset('uploads/reminder/' . $reminderdata->file)); ?>"
             alt="Reminder Image"
             style="width: 50px; height: 38px; margin-left: 10px;" />
      </a>
    <?php endif; ?>
  </div>

  <div class="error-message" id="imageerror1" style="color: red;"></div>

  <?php $__errorArgs = ['file'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
    <div class="invalid-feedback d-block">
      <?php echo e($message); ?>

    </div>
  <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
</div>

          <!-- Email -->
        

          <!-- Reminder Checkbox -->
          <div class="col-md-4 mt-3 ">
         
                <div class="form-check">
              <input class="form-check-input" type="checkbox" id="reminderCheck">
              <label class="form-check-label" for="reminderCheck">Reminder Date Time</label>
              <input type="hidden" name="reminder_status" id="reminderStatus" value="<?php echo e($reminderdata->reminder_status); ?>">
            </div>
             
         
          </div>
          <div class="col-md-8 mt-3 " >
         
                <div id="reminderDateTime">
              <label for="reminderInput" class="form-label">Select Date & Time</label>
              <input type="text" class="form-control date-time" >
            </div>
             
         
          </div>

          <div class="col-md-12 mt-3">
            <label for="email" class="form-label">Email <span class="text-danger">*</span></label>
            <input type="email" class="form-control" id="email" value="<?php echo e($reminderdata->email); ?>" name="email" data-role="tagsinput" required>
          </div>

          


<div class="col-md-12 mt-3">
  <label for="content" class="form-label">Content</label>
  <!-- Hidden field to store Quill HTML content on submit -->
  <textarea name="content" class="d-none" id="content"><?php echo e($reminderdata->content); ?></textarea>

  <!-- Editor container with fixed height and styling -->
  <div id="editor-container" style="height: 200px; border: 1px solid #ced4da; border-radius: 4px;"><?php echo $reminderdata->content; ?></div>
</div>
        <div class="col-12 text-end">
<button class="btn btn-primary" type="submit" id="submit-btn" name="submit" value="submit">
  Update
</button>
        </div>
      </div>
    </section>
  </form>
							</div>
						</div>
					</div>
				</div>
</div>
</div>

	


<?php echo $__env->make('backend/include/footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('backend/include/datatableajax/tablescript', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>



<script>
  document.getElementById('reminderCheck').addEventListener('change', function () {
    const dateTimeDiv = document.getElementById('reminderDateTime');
    const statusInput = document.getElementById('reminderStatus');

    if (this.checked) {
      dateTimeDiv.style.display = 'block';   
      statusInput.value = 1;                
    } else {
      dateTimeDiv.style.display = 'none';  
      statusInput.value = 0;                
    }
  });

  // by default hide date-time input
  document.getElementById('reminderDateTime').style.display = 'none';
</script>
   

<script>
  const quill2 = new Quill('#editor-container2', {
    modules: {
      toolbar: [
        [{ header: [1, 2, 3, 4, 5, 6, false] }],
        [{ font: [] }],
        [{ size: ['small', false, 'large', 'huge'] }],
        ['bold', 'italic', 'underline', 'strike'],
        [{ color: [] }, { background: [] }],
        [{ script: 'sub' }, { script: 'super' }],
        [{ list: 'ordered' }, { list: 'bullet' }],
        [{ indent: '-1' }, { indent: '+1' }],
        [{ align: [] }],
        ['blockquote', 'code-block'],
        ['link', 'image', 'video'],
        ['clean'],
      ],
    },
    theme: 'snow',
  });

  function myckediter() {
    document.getElementById('content').value = quill2.root.innerHTML;
  }
  document.querySelector("form").addEventListener("submit", function () {
    myckediter();
  });
</script>

</body>

</html><?php /**PATH /home/uatlocalpintu/public_html/resources/views/backend/lead/reminderedit.blade.php ENDPATH**/ ?>